package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters._
sealed trait NetworkStatus {
  def unwrap
      : software.amazon.awssdk.services.managedblockchain.model.NetworkStatus
}
object NetworkStatus {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.NetworkStatus
  ): zio.aws.managedblockchain.model.NetworkStatus = value match {
    case software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NetworkStatus =
      software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.managedblockchain.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NetworkStatus =
      software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.CREATING
  }
  case object AVAILABLE extends zio.aws.managedblockchain.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NetworkStatus =
      software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.AVAILABLE
  }
  case object CREATE_FAILED
      extends zio.aws.managedblockchain.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NetworkStatus =
      software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.CREATE_FAILED
  }
  case object DELETING extends zio.aws.managedblockchain.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NetworkStatus =
      software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.DELETING
  }
  case object DELETED extends zio.aws.managedblockchain.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NetworkStatus =
      software.amazon.awssdk.services.managedblockchain.model.NetworkStatus.DELETED
  }
}
