package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProposalActions(
    invitations: Optional[
      Iterable[zio.aws.managedblockchain.model.InviteAction]
    ] = Optional.Absent,
    removals: Optional[Iterable[zio.aws.managedblockchain.model.RemoveAction]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ProposalActions = {
    import ProposalActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ProposalActions
      .builder()
      .optionallyWith(
        invitations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invitations)
      .optionallyWith(
        removals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removals)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ProposalActions.ReadOnly =
    zio.aws.managedblockchain.model.ProposalActions.wrap(buildAwsValue())
}
object ProposalActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ProposalActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ProposalActions =
      zio.aws.managedblockchain.model.ProposalActions(
        invitations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def invitations
        : Optional[List[zio.aws.managedblockchain.model.InviteAction.ReadOnly]]
    def removals
        : Optional[List[zio.aws.managedblockchain.model.RemoveAction.ReadOnly]]
    def getInvitations: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.InviteAction.ReadOnly
    ]] = AwsError.unwrapOptionField("invitations", invitations)
    def getRemovals: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.RemoveAction.ReadOnly
    ]] = AwsError.unwrapOptionField("removals", removals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ProposalActions
  ) extends zio.aws.managedblockchain.model.ProposalActions.ReadOnly {
    override val invitations: Optional[
      List[zio.aws.managedblockchain.model.InviteAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.invitations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.managedblockchain.model.InviteAction.wrap(item)
        }.toList
      )
    override val removals: Optional[
      List[zio.aws.managedblockchain.model.RemoveAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.removals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.managedblockchain.model.RemoveAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ProposalActions
  ): zio.aws.managedblockchain.model.ProposalActions.ReadOnly = new Wrapper(
    impl
  )
}
