package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  IsOwned,
  Timestamp,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString
}
import scala.jdk.CollectionConverters._
final case class MemberSummary(
    id: Optional[ResourceIdString] = Optional.Absent,
    name: Optional[NetworkMemberNameString] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.MemberStatus] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    isOwned: Optional[IsOwned] = Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberSummary = {
    import MemberSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberSummary
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        isOwned.map(value => IsOwned.unwrap(value): java.lang.Boolean)
      )(_.isOwned)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.MemberSummary.ReadOnly =
    zio.aws.managedblockchain.model.MemberSummary.wrap(buildAwsValue())
}
object MemberSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.MemberSummary =
      zio.aws.managedblockchain.model.MemberSummary(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        isOwned.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[ResourceIdString]
    def name: Optional[NetworkMemberNameString]
    def description: Optional[DescriptionString]
    def status: Optional[zio.aws.managedblockchain.model.MemberStatus]
    def creationDate: Optional[Timestamp]
    def isOwned: Optional[IsOwned]
    def arn: Optional[ArnString]
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getIsOwned: ZIO[Any, AwsError, IsOwned] =
      AwsError.unwrapOptionField("isOwned", isOwned)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberSummary
  ) extends zio.aws.managedblockchain.model.MemberSummary.ReadOnly {
    override val id: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val name: Optional[NetworkMemberNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.managedblockchain.model.primitives
          .NetworkMemberNameString(value)
      )
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.DescriptionString(value)
        )
    override val status
        : Optional[zio.aws.managedblockchain.model.MemberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.managedblockchain.model.MemberStatus.wrap(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val isOwned: Optional[IsOwned] = zio.aws.core.internal
      .optionalFromNullable(impl.isOwned())
      .map(value => zio.aws.managedblockchain.model.primitives.IsOwned(value))
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberSummary
  ): zio.aws.managedblockchain.model.MemberSummary.ReadOnly = new Wrapper(impl)
}
