package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NetworkFabricConfiguration(
    edition: zio.aws.managedblockchain.model.Edition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NetworkFabricConfiguration = {
    import NetworkFabricConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NetworkFabricConfiguration
      .builder()
      .edition(edition.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NetworkFabricConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.NetworkFabricConfiguration
      .wrap(buildAwsValue())
}
object NetworkFabricConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NetworkFabricConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NetworkFabricConfiguration =
      zio.aws.managedblockchain.model.NetworkFabricConfiguration(edition)
    def edition: zio.aws.managedblockchain.model.Edition
    def getEdition: ZIO[Any, Nothing, zio.aws.managedblockchain.model.Edition] =
      ZIO.succeed(edition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFabricConfiguration
  ) extends zio.aws.managedblockchain.model.NetworkFabricConfiguration.ReadOnly {
    override val edition: zio.aws.managedblockchain.model.Edition =
      zio.aws.managedblockchain.model.Edition.wrap(impl.edition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFabricConfiguration
  ): zio.aws.managedblockchain.model.NetworkFabricConfiguration.ReadOnly =
    new Wrapper(impl)
}
