package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNodeResponse(nodeId: Option[ResourceIdString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse = {
    import CreateNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse
      .builder()
      .optionallyWith(
        nodeId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.nodeId)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly =
    zio.aws.managedblockchain.model.CreateNodeResponse.wrap(buildAwsValue())
}
object CreateNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateNodeResponse =
      zio.aws.managedblockchain.model
        .CreateNodeResponse(nodeId.map(value => value))
    def nodeId: Option[ResourceIdString]
    def getNodeId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("nodeId", nodeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse
  ) extends zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly {
    override val nodeId: Option[ResourceIdString] = scala
      .Option(impl.nodeId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse
  ): zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
