package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeFabricAttributes(
    peerEndpoint: Option[String] = None,
    peerEventEndpoint: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NodeFabricAttributes = {
    import NodeFabricAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NodeFabricAttributes
      .builder()
      .optionallyWith(peerEndpoint.map(value => value: java.lang.String))(
        _.peerEndpoint
      )
      .optionallyWith(peerEventEndpoint.map(value => value: java.lang.String))(
        _.peerEventEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NodeFabricAttributes.ReadOnly =
    zio.aws.managedblockchain.model.NodeFabricAttributes.wrap(buildAwsValue())
}
object NodeFabricAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NodeFabricAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NodeFabricAttributes =
      zio.aws.managedblockchain.model.NodeFabricAttributes(
        peerEndpoint.map(value => value),
        peerEventEndpoint.map(value => value)
      )
    def peerEndpoint: Option[String]
    def peerEventEndpoint: Option[String]
    def getPeerEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerEndpoint", peerEndpoint)
    def getPeerEventEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerEventEndpoint", peerEventEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeFabricAttributes
  ) extends zio.aws.managedblockchain.model.NodeFabricAttributes.ReadOnly {
    override val peerEndpoint: Option[String] =
      scala.Option(impl.peerEndpoint()).map(value => value: String)
    override val peerEventEndpoint: Option[String] =
      scala.Option(impl.peerEventEndpoint()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeFabricAttributes
  ): zio.aws.managedblockchain.model.NodeFabricAttributes.ReadOnly =
    new Wrapper(impl)
}
