package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RejectInvitationRequest(invitationId: ResourceIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest = {
    import RejectInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest
      .builder()
      .invitationId(ResourceIdString.unwrap(invitationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.RejectInvitationRequest.ReadOnly =
    zio.aws.managedblockchain.model.RejectInvitationRequest
      .wrap(buildAwsValue())
}
object RejectInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.RejectInvitationRequest =
      zio.aws.managedblockchain.model.RejectInvitationRequest(invitationId)
    def invitationId: ResourceIdString
    def getInvitationId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(invitationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest
  ) extends zio.aws.managedblockchain.model.RejectInvitationRequest.ReadOnly {
    override val invitationId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.invitationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest
  ): zio.aws.managedblockchain.model.RejectInvitationRequest.ReadOnly =
    new Wrapper(impl)
}
