package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.UsernameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MemberFabricAttributes(
    adminUsername: Option[UsernameString] = None,
    caEndpoint: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberFabricAttributes = {
    import MemberFabricAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberFabricAttributes
      .builder()
      .optionallyWith(
        adminUsername.map(value =>
          UsernameString.unwrap(value): java.lang.String
        )
      )(_.adminUsername)
      .optionallyWith(caEndpoint.map(value => value: java.lang.String))(
        _.caEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.MemberFabricAttributes.ReadOnly =
    zio.aws.managedblockchain.model.MemberFabricAttributes.wrap(buildAwsValue())
}
object MemberFabricAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberFabricAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.MemberFabricAttributes =
      zio.aws.managedblockchain.model.MemberFabricAttributes(
        adminUsername.map(value => value),
        caEndpoint.map(value => value)
      )
    def adminUsername: Option[UsernameString]
    def caEndpoint: Option[String]
    def getAdminUsername: ZIO[Any, AwsError, UsernameString] =
      AwsError.unwrapOptionField("adminUsername", adminUsername)
    def getCaEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("caEndpoint", caEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFabricAttributes
  ) extends zio.aws.managedblockchain.model.MemberFabricAttributes.ReadOnly {
    override val adminUsername: Option[UsernameString] = scala
      .Option(impl.adminUsername())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.UsernameString(value)
      )
    override val caEndpoint: Option[String] =
      scala.Option(impl.caEndpoint()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFabricAttributes
  ): zio.aws.managedblockchain.model.MemberFabricAttributes.ReadOnly =
    new Wrapper(impl)
}
