package zio.aws.managedblockchain
import zio.aws.managedblockchain.model.GetMemberResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.managedblockchain.model.{
  CreateMemberRequest,
  UpdateMemberRequest,
  GetNetworkRequest,
  RejectInvitationRequest,
  ListProposalVotesRequest,
  ListNodesRequest,
  ListMembersRequest,
  ListProposalsRequest,
  ListTagsForResourceRequest,
  UpdateNodeRequest,
  GetProposalRequest,
  CreateProposalRequest,
  GetMemberRequest,
  DeleteNodeRequest,
  ListInvitationsRequest,
  CreateNodeRequest,
  VoteOnProposalRequest,
  DeleteMemberRequest,
  UntagResourceRequest,
  GetNodeRequest,
  ListNetworksRequest,
  TagResourceRequest,
  CreateNetworkRequest
}
import software.amazon.awssdk.services.managedblockchain.{
  ManagedBlockchainAsyncClientBuilder,
  ManagedBlockchainAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.managedblockchain.model.{
  ListProposalVotesResponse,
  CreateNodeResponse,
  VoteOnProposalResponse,
  Invitation,
  DeleteNodeResponse,
  ListNodesResponse,
  MemberSummary,
  GetNodeResponse,
  ListMembersResponse,
  CreateMemberResponse,
  UpdateMemberResponse,
  CreateNetworkResponse,
  ProposalSummary,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteMemberResponse,
  CreateProposalResponse,
  NetworkSummary,
  VoteSummary,
  NodeSummary,
  UpdateNodeResponse,
  GetProposalResponse,
  ListInvitationsResponse,
  RejectInvitationResponse,
  ListProposalsResponse,
  GetNetworkResponse,
  ListNetworksResponse,
  TagResourceResponse,
  GetMemberResponse
}
import scala.jdk.CollectionConverters._
trait ManagedBlockchain extends AspectSupport[ManagedBlockchain] {
  val api: ManagedBlockchainAsyncClient
  def listProposals(request: ListProposalsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchain.model.ProposalSummary.ReadOnly
  ]
  def listProposalsPaginated(request: ListProposalsRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly
  ]
  def getNetwork(
      request: GetNetworkRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly]
  def createNode(
      request: CreateNodeRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly]
  def createMember(
      request: CreateMemberRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly]
  def updateNode(
      request: UpdateNodeRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.UpdateNodeResponse.ReadOnly]
  def createNetwork(request: CreateNetworkRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly
  ]
  def getNode(
      request: GetNodeRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly]
  def deleteNode(
      request: DeleteNodeRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.DeleteNodeResponse.ReadOnly]
  def listMembers(request: ListMembersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchain.model.MemberSummary.ReadOnly
  ]
  def listMembersPaginated(
      request: ListMembersRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly]
  def getProposal(
      request: GetProposalRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly]
  def updateMember(
      request: UpdateMemberRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.UpdateMemberResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.UntagResourceResponse.ReadOnly
  ]
  def getMember(request: GetMemberRequest): IO[AwsError, ReadOnly]
  def listNetworks(request: ListNetworksRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchain.model.NetworkSummary.ReadOnly
  ]
  def listNetworksPaginated(
      request: ListNetworksRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly]
  def deleteMember(
      request: DeleteMemberRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.DeleteMemberResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.TagResourceResponse.ReadOnly]
  def listProposalVotes(request: ListProposalVotesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchain.model.VoteSummary.ReadOnly
  ]
  def listProposalVotesPaginated(request: ListProposalVotesRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly
  ]
  def listInvitations(
      request: ListInvitationsRequest
  ): ZStream[Any, AwsError, zio.aws.managedblockchain.model.Invitation.ReadOnly]
  def listInvitationsPaginated(request: ListInvitationsRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly
  ]
  def voteOnProposal(request: VoteOnProposalRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.VoteOnProposalResponse.ReadOnly
  ]
  def rejectInvitation(request: RejectInvitationRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.RejectInvitationResponse.ReadOnly
  ]
  def createProposal(request: CreateProposalRequest): IO[
    AwsError,
    zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly
  ]
  def listNodes(request: ListNodesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchain.model.NodeSummary.ReadOnly
  ]
  def listNodesPaginated(
      request: ListNodesRequest
  ): IO[AwsError, zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly]
}
object ManagedBlockchain {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ManagedBlockchain] =
    customized(identity)
  def customized(
      customization: ManagedBlockchainAsyncClientBuilder => ManagedBlockchainAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ManagedBlockchain] = managed(
    customization
  ).toLayer
  def managed(
      customization: ManagedBlockchainAsyncClientBuilder => ManagedBlockchainAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ManagedBlockchain] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ManagedBlockchainAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ManagedBlockchainAsyncClient,
        ManagedBlockchainAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ManagedBlockchainAsyncClient,
        ManagedBlockchainAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ManagedBlockchainImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ManagedBlockchainImpl[R](
      override val api: ManagedBlockchainAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ManagedBlockchain
      with AwsServiceBase[R] {
    override val serviceName: String = "ManagedBlockchain"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ManagedBlockchainImpl[R1] = new ManagedBlockchainImpl(api, newAspect, r)
    def listProposals(request: ListProposalsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.ProposalSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest,
      ListProposalsResponse,
      ProposalSummary
    ](
      "listProposals",
      api.listProposals,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.proposals().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.managedblockchain.model.ProposalSummary.wrap(item))
      .provideEnvironment(r)
    def listProposalsPaginated(request: ListProposalsRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest,
      ListProposalsResponse
    ]("listProposals", api.listProposals)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.ListProposalsResponse.wrap)
      .provideEnvironment(r)
    def getNetwork(request: GetNetworkRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest,
      GetNetworkResponse
    ]("getNetwork", api.getNetwork)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.GetNetworkResponse.wrap)
      .provideEnvironment(r)
    def createNode(request: CreateNodeRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest,
      CreateNodeResponse
    ]("createNode", api.createNode)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.CreateNodeResponse.wrap)
      .provideEnvironment(r)
    def createMember(request: CreateMemberRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest,
      CreateMemberResponse
    ]("createMember", api.createMember)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.CreateMemberResponse.wrap)
      .provideEnvironment(r)
    def updateNode(request: UpdateNodeRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.UpdateNodeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest,
      UpdateNodeResponse
    ]("updateNode", api.updateNode)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.UpdateNodeResponse.wrap)
      .provideEnvironment(r)
    def createNetwork(request: CreateNetworkRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest,
      CreateNetworkResponse
    ]("createNetwork", api.createNetwork)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.CreateNetworkResponse.wrap)
      .provideEnvironment(r)
    def getNode(
        request: GetNodeRequest
    ): IO[AwsError, zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.managedblockchain.model.GetNodeRequest,
        GetNodeResponse
      ]("getNode", api.getNode)(request.buildAwsValue())
        .map(zio.aws.managedblockchain.model.GetNodeResponse.wrap)
        .provideEnvironment(r)
    def deleteNode(request: DeleteNodeRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.DeleteNodeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest,
      DeleteNodeResponse
    ]("deleteNode", api.deleteNode)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.DeleteNodeResponse.wrap)
      .provideEnvironment(r)
    def listMembers(request: ListMembersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest,
      ListMembersResponse,
      MemberSummary
    ](
      "listMembers",
      api.listMembers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.members().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.managedblockchain.model.MemberSummary.wrap(item))
      .provideEnvironment(r)
    def listMembersPaginated(request: ListMembersRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest,
      ListMembersResponse
    ]("listMembers", api.listMembers)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.ListMembersResponse.wrap)
      .provideEnvironment(r)
    def getProposal(request: GetProposalRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest,
      GetProposalResponse
    ]("getProposal", api.getProposal)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.GetProposalResponse.wrap)
      .provideEnvironment(r)
    def updateMember(request: UpdateMemberRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.UpdateMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest,
      UpdateMemberResponse
    ]("updateMember", api.updateMember)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.UpdateMemberResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getMember(request: GetMemberRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest,
        GetMemberResponse
      ]("getMember", api.getMember)(request.buildAwsValue())
        .map(zio.aws.managedblockchain.model.GetMemberResponse.wrap)
        .provideEnvironment(r)
    def listNetworks(request: ListNetworksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest,
      ListNetworksResponse,
      NetworkSummary
    ](
      "listNetworks",
      api.listNetworks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.managedblockchain.model.NetworkSummary.wrap(item))
      .provideEnvironment(r)
    def listNetworksPaginated(request: ListNetworksRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest,
      ListNetworksResponse
    ]("listNetworks", api.listNetworks)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.ListNetworksResponse.wrap)
      .provideEnvironment(r)
    def deleteMember(request: DeleteMemberRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.DeleteMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest,
      DeleteMemberResponse
    ]("deleteMember", api.deleteMember)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.DeleteMemberResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def listProposalVotes(request: ListProposalVotesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.VoteSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest,
      ListProposalVotesResponse,
      VoteSummary
    ](
      "listProposalVotes",
      api.listProposalVotes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.proposalVotes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.managedblockchain.model.VoteSummary.wrap(item))
      .provideEnvironment(r)
    def listProposalVotesPaginated(request: ListProposalVotesRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest,
      ListProposalVotesResponse
    ]("listProposalVotes", api.listProposalVotes)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.ListProposalVotesResponse.wrap)
      .provideEnvironment(r)
    def listInvitations(request: ListInvitationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.Invitation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest,
      ListInvitationsResponse,
      Invitation
    ](
      "listInvitations",
      api.listInvitations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.invitations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.managedblockchain.model.Invitation.wrap(item))
      .provideEnvironment(r)
    def listInvitationsPaginated(request: ListInvitationsRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest,
      ListInvitationsResponse
    ]("listInvitations", api.listInvitations)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.ListInvitationsResponse.wrap)
      .provideEnvironment(r)
    def voteOnProposal(request: VoteOnProposalRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.VoteOnProposalResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest,
      VoteOnProposalResponse
    ]("voteOnProposal", api.voteOnProposal)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.VoteOnProposalResponse.wrap)
      .provideEnvironment(r)
    def rejectInvitation(request: RejectInvitationRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.RejectInvitationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest,
      RejectInvitationResponse
    ]("rejectInvitation", api.rejectInvitation)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.RejectInvitationResponse.wrap)
      .provideEnvironment(r)
    def createProposal(request: CreateProposalRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest,
      CreateProposalResponse
    ]("createProposal", api.createProposal)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.CreateProposalResponse.wrap)
      .provideEnvironment(r)
    def listNodes(request: ListNodesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest,
      ListNodesResponse,
      NodeSummary
    ](
      "listNodes",
      api.listNodes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.nodes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.managedblockchain.model.NodeSummary.wrap(item))
      .provideEnvironment(r)
    def listNodesPaginated(request: ListNodesRequest): IO[
      AwsError,
      zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest,
      ListNodesResponse
    ]("listNodes", api.listNodes)(request.buildAwsValue())
      .map(zio.aws.managedblockchain.model.ListNodesResponse.wrap)
      .provideEnvironment(r)
  }
  def listProposals(request: ListProposalsRequest): ZStream[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ProposalSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProposals(request))
  def listProposalsPaginated(request: ListProposalsRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProposalsPaginated(request))
  def getNetwork(request: GetNetworkRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetwork(request))
  def createNode(request: CreateNodeRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNode(request))
  def createMember(request: CreateMemberRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMember(request))
  def updateNode(request: UpdateNodeRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.UpdateNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNode(request))
  def createNetwork(request: CreateNetworkRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetwork(request))
  def getNode(request: GetNodeRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNode(request))
  def deleteNode(request: DeleteNodeRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.DeleteNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNode(request))
  def listMembers(request: ListMembersRequest): ZStream[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.MemberSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMembers(request))
  def listMembersPaginated(request: ListMembersRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMembersPaginated(request))
  def getProposal(request: GetProposalRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProposal(request))
  def updateMember(request: UpdateMemberRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.UpdateMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMember(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getMember(
      request: GetMemberRequest
  ): ZIO[zio.aws.managedblockchain.ManagedBlockchain, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getMember(request))
  def listNetworks(request: ListNetworksRequest): ZStream[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.NetworkSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listNetworks(request))
  def listNetworksPaginated(request: ListNetworksRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNetworksPaginated(request))
  def deleteMember(request: DeleteMemberRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.DeleteMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMember(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listProposalVotes(request: ListProposalVotesRequest): ZStream[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.VoteSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProposalVotes(request))
  def listProposalVotesPaginated(request: ListProposalVotesRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProposalVotesPaginated(request))
  def listInvitations(request: ListInvitationsRequest): ZStream[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.Invitation.ReadOnly
  ] = ZStream.serviceWithStream(_.listInvitations(request))
  def listInvitationsPaginated(request: ListInvitationsRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInvitationsPaginated(request))
  def voteOnProposal(request: VoteOnProposalRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.VoteOnProposalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.voteOnProposal(request))
  def rejectInvitation(request: RejectInvitationRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.RejectInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectInvitation(request))
  def createProposal(request: CreateProposalRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProposal(request))
  def listNodes(request: ListNodesRequest): ZStream[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.NodeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listNodes(request))
  def listNodesPaginated(request: ListNodesRequest): ZIO[
    zio.aws.managedblockchain.ManagedBlockchain,
    AwsError,
    zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNodesPaginated(request))
}
