package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  TagValue,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Member(
    networkId: Option[ResourceIdString] = None,
    id: Option[ResourceIdString] = None,
    name: Option[NetworkMemberNameString] = None,
    description: Option[DescriptionString] = None,
    frameworkAttributes: Option[
      zio.aws.managedblockchain.model.MemberFrameworkAttributes
    ] = None,
    logPublishingConfiguration: Option[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
    ] = None,
    status: Option[zio.aws.managedblockchain.model.MemberStatus] = None,
    creationDate: Option[Timestamp] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    arn: Option[ArnString] = None,
    kmsKeyArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Member = {
    import Member.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Member
      .builder()
      .optionallyWith(
        networkId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.networkId)
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(frameworkAttributes.map(value => value.buildAwsValue()))(
        _.frameworkAttributes
      )
      .optionallyWith(
        logPublishingConfiguration.map(value => value.buildAwsValue())
      )(_.logPublishingConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Member.ReadOnly =
    zio.aws.managedblockchain.model.Member.wrap(buildAwsValue())
}
object Member {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Member
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Member =
      zio.aws.managedblockchain.model.Member(
        networkId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        frameworkAttributes.map(value => value.asEditable),
        logPublishingConfiguration.map(value => value.asEditable),
        status.map(value => value),
        creationDate.map(value => value),
        tags.map(value => value),
        arn.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def networkId: Option[ResourceIdString]
    def id: Option[ResourceIdString]
    def name: Option[NetworkMemberNameString]
    def description: Option[DescriptionString]
    def frameworkAttributes: Option[
      zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly
    ]
    def logPublishingConfiguration: Option[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ]
    def status: Option[zio.aws.managedblockchain.model.MemberStatus]
    def creationDate: Option[Timestamp]
    def tags: Option[Map[TagKey, TagValue]]
    def arn: Option[ArnString]
    def kmsKeyArn: Option[String]
    def getNetworkId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getFrameworkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("frameworkAttributes", frameworkAttributes)
    def getLogPublishingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logPublishingConfiguration",
      logPublishingConfiguration
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
    def getKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Member
  ) extends zio.aws.managedblockchain.model.Member.ReadOnly {
    override val networkId: Option[ResourceIdString] = scala
      .Option(impl.networkId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val id: Option[ResourceIdString] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val name: Option[NetworkMemberNameString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.managedblockchain.model.primitives
          .NetworkMemberNameString(value)
      )
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val frameworkAttributes: Option[
      zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly
    ] = scala
      .Option(impl.frameworkAttributes())
      .map(value =>
        zio.aws.managedblockchain.model.MemberFrameworkAttributes.wrap(value)
      )
    override val logPublishingConfiguration: Option[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = scala
      .Option(impl.logPublishingConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
          .wrap(value)
      )
    override val status: Option[zio.aws.managedblockchain.model.MemberStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.MemberStatus.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val arn: Option[ArnString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
    override val kmsKeyArn: Option[String] =
      scala.Option(impl.kmsKeyArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Member
  ): zio.aws.managedblockchain.model.Member.ReadOnly = new Wrapper(impl)
}
