package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAccessorRequest(accessorId: ResourceIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetAccessorRequest = {
    import GetAccessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetAccessorRequest
      .builder()
      .accessorId(ResourceIdString.unwrap(accessorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetAccessorRequest.ReadOnly =
    zio.aws.managedblockchain.model.GetAccessorRequest.wrap(buildAwsValue())
}
object GetAccessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetAccessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetAccessorRequest =
      zio.aws.managedblockchain.model.GetAccessorRequest(accessorId)
    def accessorId: ResourceIdString
    def getAccessorId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(accessorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetAccessorRequest
  ) extends zio.aws.managedblockchain.model.GetAccessorRequest.ReadOnly {
    override val accessorId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.accessorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetAccessorRequest
  ): zio.aws.managedblockchain.model.GetAccessorRequest.ReadOnly = new Wrapper(
    impl
  )
}
