package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  ArnString,
  Timestamp,
  ResourceIdString
}
import scala.jdk.CollectionConverters._
final case class AccessorSummary(
    id: Optional[ResourceIdString] = Optional.Absent,
    `type`: Optional[zio.aws.managedblockchain.model.AccessorType] =
      Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.AccessorStatus] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.AccessorSummary = {
    import AccessorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.AccessorSummary
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.AccessorSummary.ReadOnly =
    zio.aws.managedblockchain.model.AccessorSummary.wrap(buildAwsValue())
}
object AccessorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.AccessorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.AccessorSummary =
      zio.aws.managedblockchain.model.AccessorSummary(
        id.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[ResourceIdString]
    def `type`: Optional[zio.aws.managedblockchain.model.AccessorType]
    def status: Optional[zio.aws.managedblockchain.model.AccessorStatus]
    def creationDate: Optional[Timestamp]
    def arn: Optional[ArnString]
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getType
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.AccessorType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.AccessorStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.AccessorSummary
  ) extends zio.aws.managedblockchain.model.AccessorSummary.ReadOnly {
    override val id: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val `type`
        : Optional[zio.aws.managedblockchain.model.AccessorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.managedblockchain.model.AccessorType.wrap(value))
    override val status
        : Optional[zio.aws.managedblockchain.model.AccessorStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.managedblockchain.model.AccessorStatus.wrap(value)
        )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.AccessorSummary
  ): zio.aws.managedblockchain.model.AccessorSummary.ReadOnly = new Wrapper(
    impl
  )
}
