package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMemberRequest(
    networkId: ResourceIdString,
    memberId: ResourceIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest = {
    import GetMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .memberId(ResourceIdString.unwrap(memberId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetMemberRequest.ReadOnly =
    zio.aws.managedblockchain.model.GetMemberRequest.wrap(buildAwsValue())
}
object GetMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetMemberRequest =
      zio.aws.managedblockchain.model.GetMemberRequest(networkId, memberId)
    def networkId: ResourceIdString
    def memberId: ResourceIdString
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, Nothing, ResourceIdString] = ZIO.succeed(memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest
  ) extends zio.aws.managedblockchain.model.GetMemberRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.memberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest
  ): zio.aws.managedblockchain.model.GetMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
