package zio.aws.managedblockchain
import zio.aws.managedblockchain.model.GetMemberResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.managedblockchain.model.{
  CreateMemberRequest,
  UpdateMemberRequest,
  GetNetworkRequest,
  RejectInvitationRequest,
  ListProposalVotesRequest,
  CreateAccessorRequest,
  ListNodesRequest,
  ListMembersRequest,
  ListProposalsRequest,
  ListAccessorsRequest,
  ListTagsForResourceRequest,
  UpdateNodeRequest,
  GetProposalRequest,
  DeleteAccessorRequest,
  CreateProposalRequest,
  GetMemberRequest,
  DeleteNodeRequest,
  GetAccessorRequest,
  ListInvitationsRequest,
  CreateNodeRequest,
  VoteOnProposalRequest,
  DeleteMemberRequest,
  UntagResourceRequest,
  GetNodeRequest,
  ListNetworksRequest,
  TagResourceRequest,
  CreateNetworkRequest
}
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClient
import zio.stream.ZStream
object ManagedBlockchainMock extends Mock[ManagedBlockchain] {
  object ListAccessors
      extends Stream[
        ListAccessorsRequest,
        AwsError,
        zio.aws.managedblockchain.model.AccessorSummary.ReadOnly
      ]
  object ListAccessorsPaginated
      extends Effect[
        ListAccessorsRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListAccessorsResponse.ReadOnly
      ]
  object GetAccessor
      extends Effect[
        GetAccessorRequest,
        AwsError,
        zio.aws.managedblockchain.model.GetAccessorResponse.ReadOnly
      ]
  object ListProposals
      extends Stream[
        ListProposalsRequest,
        AwsError,
        zio.aws.managedblockchain.model.ProposalSummary.ReadOnly
      ]
  object ListProposalsPaginated
      extends Effect[
        ListProposalsRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly
      ]
  object GetNetwork
      extends Effect[
        GetNetworkRequest,
        AwsError,
        zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly
      ]
  object CreateNode
      extends Effect[
        CreateNodeRequest,
        AwsError,
        zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly
      ]
  object CreateMember
      extends Effect[
        CreateMemberRequest,
        AwsError,
        zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly
      ]
  object UpdateNode
      extends Effect[
        UpdateNodeRequest,
        AwsError,
        zio.aws.managedblockchain.model.UpdateNodeResponse.ReadOnly
      ]
  object CreateNetwork
      extends Effect[
        CreateNetworkRequest,
        AwsError,
        zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly
      ]
  object GetNode
      extends Effect[
        GetNodeRequest,
        AwsError,
        zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly
      ]
  object DeleteNode
      extends Effect[
        DeleteNodeRequest,
        AwsError,
        zio.aws.managedblockchain.model.DeleteNodeResponse.ReadOnly
      ]
  object ListMembers
      extends Stream[
        ListMembersRequest,
        AwsError,
        zio.aws.managedblockchain.model.MemberSummary.ReadOnly
      ]
  object ListMembersPaginated
      extends Effect[
        ListMembersRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly
      ]
  object DeleteAccessor
      extends Effect[
        DeleteAccessorRequest,
        AwsError,
        zio.aws.managedblockchain.model.DeleteAccessorResponse.ReadOnly
      ]
  object GetProposal
      extends Effect[
        GetProposalRequest,
        AwsError,
        zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly
      ]
  object CreateAccessor
      extends Effect[
        CreateAccessorRequest,
        AwsError,
        zio.aws.managedblockchain.model.CreateAccessorResponse.ReadOnly
      ]
  object UpdateMember
      extends Effect[
        UpdateMemberRequest,
        AwsError,
        zio.aws.managedblockchain.model.UpdateMemberResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.managedblockchain.model.UntagResourceResponse.ReadOnly
      ]
  object GetMember extends Effect[GetMemberRequest, AwsError, ReadOnly]
  object ListNetworks
      extends Stream[
        ListNetworksRequest,
        AwsError,
        zio.aws.managedblockchain.model.NetworkSummary.ReadOnly
      ]
  object ListNetworksPaginated
      extends Effect[
        ListNetworksRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly
      ]
  object DeleteMember
      extends Effect[
        DeleteMemberRequest,
        AwsError,
        zio.aws.managedblockchain.model.DeleteMemberResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.managedblockchain.model.TagResourceResponse.ReadOnly
      ]
  object ListProposalVotes
      extends Stream[
        ListProposalVotesRequest,
        AwsError,
        zio.aws.managedblockchain.model.VoteSummary.ReadOnly
      ]
  object ListProposalVotesPaginated
      extends Effect[
        ListProposalVotesRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly
      ]
  object ListInvitations
      extends Stream[
        ListInvitationsRequest,
        AwsError,
        zio.aws.managedblockchain.model.Invitation.ReadOnly
      ]
  object ListInvitationsPaginated
      extends Effect[
        ListInvitationsRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly
      ]
  object VoteOnProposal
      extends Effect[
        VoteOnProposalRequest,
        AwsError,
        zio.aws.managedblockchain.model.VoteOnProposalResponse.ReadOnly
      ]
  object RejectInvitation
      extends Effect[
        RejectInvitationRequest,
        AwsError,
        zio.aws.managedblockchain.model.RejectInvitationResponse.ReadOnly
      ]
  object CreateProposal
      extends Effect[
        CreateProposalRequest,
        AwsError,
        zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly
      ]
  object ListNodes
      extends Stream[
        ListNodesRequest,
        AwsError,
        zio.aws.managedblockchain.model.NodeSummary.ReadOnly
      ]
  object ListNodesPaginated
      extends Effect[
        ListNodesRequest,
        AwsError,
        zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ManagedBlockchain] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ManagedBlockchain] { rts =>
        zio.ZIO.succeed {
          new ManagedBlockchain {
            val api: ManagedBlockchainAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ManagedBlockchain = this
            def listAccessors(request: ListAccessorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchain.model.AccessorSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccessors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccessorsPaginated(request: ListAccessorsRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListAccessorsResponse.ReadOnly
            ] = proxy(ListAccessorsPaginated, request)
            def getAccessor(request: GetAccessorRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.GetAccessorResponse.ReadOnly
            ] = proxy(GetAccessor, request)
            def listProposals(request: ListProposalsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchain.model.ProposalSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProposals, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProposalsPaginated(request: ListProposalsRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly
            ] = proxy(ListProposalsPaginated, request)
            def getNetwork(request: GetNetworkRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly
            ] = proxy(GetNetwork, request)
            def createNode(request: CreateNodeRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.CreateNodeResponse.ReadOnly
            ] = proxy(CreateNode, request)
            def createMember(request: CreateMemberRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly
            ] = proxy(CreateMember, request)
            def updateNode(request: UpdateNodeRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.UpdateNodeResponse.ReadOnly
            ] = proxy(UpdateNode, request)
            def createNetwork(request: CreateNetworkRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly
            ] = proxy(CreateNetwork, request)
            def getNode(request: GetNodeRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly
            ] = proxy(GetNode, request)
            def deleteNode(request: DeleteNodeRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.DeleteNodeResponse.ReadOnly
            ] = proxy(DeleteNode, request)
            def listMembers(request: ListMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchain.model.MemberSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMembersPaginated(request: ListMembersRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly
            ] = proxy(ListMembersPaginated, request)
            def deleteAccessor(request: DeleteAccessorRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.DeleteAccessorResponse.ReadOnly
            ] = proxy(DeleteAccessor, request)
            def getProposal(request: GetProposalRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly
            ] = proxy(GetProposal, request)
            def createAccessor(request: CreateAccessorRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.CreateAccessorResponse.ReadOnly
            ] = proxy(CreateAccessor, request)
            def updateMember(request: UpdateMemberRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.UpdateMemberResponse.ReadOnly
            ] = proxy(UpdateMember, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getMember(request: GetMemberRequest): IO[AwsError, ReadOnly] =
              proxy(GetMember, request)
            def listNetworks(request: ListNetworksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchain.model.NetworkSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNetworks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNetworksPaginated(request: ListNetworksRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly
            ] = proxy(ListNetworksPaginated, request)
            def deleteMember(request: DeleteMemberRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.DeleteMemberResponse.ReadOnly
            ] = proxy(DeleteMember, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listProposalVotes(request: ListProposalVotesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchain.model.VoteSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProposalVotes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProposalVotesPaginated(
                request: ListProposalVotesRequest
            ): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly
            ] = proxy(ListProposalVotesPaginated, request)
            def listInvitations(request: ListInvitationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchain.model.Invitation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInvitations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInvitationsPaginated(request: ListInvitationsRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly
            ] = proxy(ListInvitationsPaginated, request)
            def voteOnProposal(request: VoteOnProposalRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.VoteOnProposalResponse.ReadOnly
            ] = proxy(VoteOnProposal, request)
            def rejectInvitation(request: RejectInvitationRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.RejectInvitationResponse.ReadOnly
            ] = proxy(RejectInvitation, request)
            def createProposal(request: CreateProposalRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly
            ] = proxy(CreateProposal, request)
            def listNodes(request: ListNodesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchain.model.NodeSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNodes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNodesPaginated(request: ListNodesRequest): IO[
              AwsError,
              zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly
            ] = proxy(ListNodesPaginated, request)
          }
        }
      }
    }
  }
}
