package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateNodeRequest(
    networkId: ResourceIdString,
    memberId: Optional[ResourceIdString] = Optional.Absent,
    nodeId: ResourceIdString,
    logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest = {
    import UpdateNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .nodeId(ResourceIdString.unwrap(nodeId): java.lang.String)
      .optionallyWith(
        logPublishingConfiguration.map(value => value.buildAwsValue())
      )(_.logPublishingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.UpdateNodeRequest.ReadOnly =
    zio.aws.managedblockchain.model.UpdateNodeRequest.wrap(buildAwsValue())
}
object UpdateNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.UpdateNodeRequest =
      zio.aws.managedblockchain.model.UpdateNodeRequest(
        networkId,
        memberId.map(value => value),
        nodeId,
        logPublishingConfiguration.map(value => value.asEditable)
      )
    def networkId: ResourceIdString
    def memberId: Optional[ResourceIdString]
    def nodeId: ResourceIdString
    def logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ]
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getNodeId: ZIO[Any, Nothing, ResourceIdString] = ZIO.succeed(nodeId)
    def getLogPublishingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logPublishingConfiguration",
      logPublishingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest
  ) extends zio.aws.managedblockchain.model.UpdateNodeRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val nodeId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives.ResourceIdString(impl.nodeId())
    override val logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.NodeLogPublishingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest
  ): zio.aws.managedblockchain.model.UpdateNodeRequest.ReadOnly = new Wrapper(
    impl
  )
}
