package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters._
sealed trait NodeStatus {
  def unwrap: software.amazon.awssdk.services.managedblockchain.model.NodeStatus
}
object NodeStatus {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.NodeStatus
  ): zio.aws.managedblockchain.model.NodeStatus = value match {
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.managedblockchain.model.NodeStatus.INACCESSIBLE_ENCRYPTION_KEY =>
      val r = INACCESSIBLE_ENCRYPTION_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.CREATING
  }
  case object AVAILABLE extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.AVAILABLE
  }
  case object UNHEALTHY extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.UNHEALTHY
  }
  case object CREATE_FAILED extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.CREATE_FAILED
  }
  case object UPDATING extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.UPDATING
  }
  case object DELETING extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.DELETING
  }
  case object DELETED extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.DELETED
  }
  case object FAILED extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.FAILED
  }
  case object INACCESSIBLE_ENCRYPTION_KEY
      extends zio.aws.managedblockchain.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.NodeStatus =
      software.amazon.awssdk.services.managedblockchain.model.NodeStatus.INACCESSIBLE_ENCRYPTION_KEY
  }
}
