package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters._
sealed trait StateDBType {
  def unwrap
      : software.amazon.awssdk.services.managedblockchain.model.StateDBType
}
object StateDBType {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.StateDBType
  ): zio.aws.managedblockchain.model.StateDBType = value match {
    case software.amazon.awssdk.services.managedblockchain.model.StateDBType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.StateDBType.LEVEL_DB =>
      val r = LevelDB
      r
    case software.amazon.awssdk.services.managedblockchain.model.StateDBType.COUCH_DB =>
      val r = CouchDB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.StateDBType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.StateDBType =
      software.amazon.awssdk.services.managedblockchain.model.StateDBType.UNKNOWN_TO_SDK_VERSION
  }
  case object LevelDB extends zio.aws.managedblockchain.model.StateDBType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.StateDBType =
      software.amazon.awssdk.services.managedblockchain.model.StateDBType.LEVEL_DB
  }
  case object CouchDB extends zio.aws.managedblockchain.model.StateDBType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.StateDBType =
      software.amazon.awssdk.services.managedblockchain.model.StateDBType.COUCH_DB
  }
}
