package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMemberRequest(
    networkId: ResourceIdString,
    memberId: ResourceIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest = {
    import DeleteMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .memberId(ResourceIdString.unwrap(memberId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.DeleteMemberRequest.ReadOnly =
    zio.aws.managedblockchain.model.DeleteMemberRequest.wrap(buildAwsValue())
}
object DeleteMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.DeleteMemberRequest =
      zio.aws.managedblockchain.model.DeleteMemberRequest(networkId, memberId)
    def networkId: ResourceIdString
    def memberId: ResourceIdString
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, Nothing, ResourceIdString] = ZIO.succeed(memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest
  ) extends zio.aws.managedblockchain.model.DeleteMemberRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.memberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest
  ): zio.aws.managedblockchain.model.DeleteMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
