package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters._
sealed trait Framework {
  def unwrap: software.amazon.awssdk.services.managedblockchain.model.Framework
}
object Framework {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.Framework
  ): zio.aws.managedblockchain.model.Framework = value match {
    case software.amazon.awssdk.services.managedblockchain.model.Framework.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.Framework.HYPERLEDGER_FABRIC =>
      val r = HYPERLEDGER_FABRIC
      r
    case software.amazon.awssdk.services.managedblockchain.model.Framework.ETHEREUM =>
      val r = ETHEREUM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.Framework =
      software.amazon.awssdk.services.managedblockchain.model.Framework.UNKNOWN_TO_SDK_VERSION
  }
  case object HYPERLEDGER_FABRIC
      extends zio.aws.managedblockchain.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.Framework =
      software.amazon.awssdk.services.managedblockchain.model.Framework.HYPERLEDGER_FABRIC
  }
  case object ETHEREUM extends zio.aws.managedblockchain.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.Framework =
      software.amazon.awssdk.services.managedblockchain.model.Framework.ETHEREUM
  }
}
