package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMemberResponse(
    memberId: Optional[ResourceIdString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse = {
    import CreateMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse
      .builder()
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly =
    zio.aws.managedblockchain.model.CreateMemberResponse.wrap(buildAwsValue())
}
object CreateMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateMemberResponse =
      zio.aws.managedblockchain.model
        .CreateMemberResponse(memberId.map(value => value))
    def memberId: Optional[ResourceIdString]
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse
  ) extends zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly {
    override val memberId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse
  ): zio.aws.managedblockchain.model.CreateMemberResponse.ReadOnly =
    new Wrapper(impl)
}
