package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString
}
import scala.jdk.CollectionConverters._
final case class ProposalSummary(
    proposalId: Optional[ResourceIdString] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    proposedByMemberId: Optional[ResourceIdString] = Optional.Absent,
    proposedByMemberName: Optional[NetworkMemberNameString] = Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.ProposalStatus] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    expirationDate: Optional[Timestamp] = Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ProposalSummary = {
    import ProposalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
      .builder()
      .optionallyWith(
        proposalId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposalId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        proposedByMemberId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberId)
      .optionallyWith(
        proposedByMemberName.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ProposalSummary.ReadOnly =
    zio.aws.managedblockchain.model.ProposalSummary.wrap(buildAwsValue())
}
object ProposalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ProposalSummary =
      zio.aws.managedblockchain.model.ProposalSummary(
        proposalId.map(value => value),
        description.map(value => value),
        proposedByMemberId.map(value => value),
        proposedByMemberName.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        expirationDate.map(value => value),
        arn.map(value => value)
      )
    def proposalId: Optional[ResourceIdString]
    def description: Optional[DescriptionString]
    def proposedByMemberId: Optional[ResourceIdString]
    def proposedByMemberName: Optional[NetworkMemberNameString]
    def status: Optional[zio.aws.managedblockchain.model.ProposalStatus]
    def creationDate: Optional[Timestamp]
    def expirationDate: Optional[Timestamp]
    def arn: Optional[ArnString]
    def getProposalId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposalId", proposalId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getProposedByMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposedByMemberId", proposedByMemberId)
    def getProposedByMemberName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("proposedByMemberName", proposedByMemberName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.ProposalStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
  ) extends zio.aws.managedblockchain.model.ProposalSummary.ReadOnly {
    override val proposalId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.proposalId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.DescriptionString(value)
        )
    override val proposedByMemberId: Optional[ResourceIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proposedByMemberId())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
        )
    override val proposedByMemberName: Optional[NetworkMemberNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proposedByMemberName())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .NetworkMemberNameString(value)
        )
    override val status
        : Optional[zio.aws.managedblockchain.model.ProposalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.managedblockchain.model.ProposalStatus.wrap(value)
        )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
  ): zio.aws.managedblockchain.model.ProposalSummary.ReadOnly = new Wrapper(
    impl
  )
}
