package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  ResourceIdString,
  ClientRequestTokenString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateMemberRequest(
    clientRequestToken: ClientRequestTokenString,
    invitationId: ResourceIdString,
    networkId: ResourceIdString,
    memberConfiguration: zio.aws.managedblockchain.model.MemberConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest = {
    import CreateMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest
      .builder()
      .clientRequestToken(
        ClientRequestTokenString.unwrap(clientRequestToken): java.lang.String
      )
      .invitationId(ResourceIdString.unwrap(invitationId): java.lang.String)
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .memberConfiguration(memberConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.CreateMemberRequest.ReadOnly =
    zio.aws.managedblockchain.model.CreateMemberRequest.wrap(buildAwsValue())
}
object CreateMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateMemberRequest =
      zio.aws.managedblockchain.model.CreateMemberRequest(
        clientRequestToken,
        invitationId,
        networkId,
        memberConfiguration.asEditable
      )
    def clientRequestToken: ClientRequestTokenString
    def invitationId: ResourceIdString
    def networkId: ResourceIdString
    def memberConfiguration
        : zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestTokenString] =
      ZIO.succeed(clientRequestToken)
    def getInvitationId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(invitationId)
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly
    ] = ZIO.succeed(memberConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest
  ) extends zio.aws.managedblockchain.model.CreateMemberRequest.ReadOnly {
    override val clientRequestToken: ClientRequestTokenString =
      zio.aws.managedblockchain.model.primitives
        .ClientRequestTokenString(impl.clientRequestToken())
    override val invitationId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.invitationId())
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberConfiguration
        : zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly =
      zio.aws.managedblockchain.model.MemberConfiguration
        .wrap(impl.memberConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest
  ): zio.aws.managedblockchain.model.CreateMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
