package zio.aws.managedblockchain.model
import java.lang.Integer
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  ProposalListMaxResults,
  ResourceIdString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProposalsRequest(
    networkId: ResourceIdString,
    maxResults: Option[ProposalListMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest = {
    import ListProposalsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ProposalListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListProposalsRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListProposalsRequest.wrap(buildAwsValue())
}
object ListProposalsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListProposalsRequest =
      zio.aws.managedblockchain.model.ListProposalsRequest(
        networkId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkId: ResourceIdString
    def maxResults: Option[ProposalListMaxResults]
    def nextToken: Option[PaginationToken]
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMaxResults: ZIO[Any, AwsError, ProposalListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest
  ) extends zio.aws.managedblockchain.model.ListProposalsRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val maxResults: Option[ProposalListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ProposalListMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest
  ): zio.aws.managedblockchain.model.ListProposalsRequest.ReadOnly =
    new Wrapper(impl)
}
