package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  PasswordString,
  UsernameString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MemberFabricConfiguration(
    adminUsername: UsernameString,
    adminPassword: PasswordString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberFabricConfiguration = {
    import MemberFabricConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberFabricConfiguration
      .builder()
      .adminUsername(UsernameString.unwrap(adminUsername): java.lang.String)
      .adminPassword(PasswordString.unwrap(adminPassword): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.MemberFabricConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.MemberFabricConfiguration
      .wrap(buildAwsValue())
}
object MemberFabricConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberFabricConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.MemberFabricConfiguration =
      zio.aws.managedblockchain.model
        .MemberFabricConfiguration(adminUsername, adminPassword)
    def adminUsername: UsernameString
    def adminPassword: PasswordString
    def getAdminUsername: ZIO[Any, Nothing, UsernameString] =
      ZIO.succeed(adminUsername)
    def getAdminPassword: ZIO[Any, Nothing, PasswordString] =
      ZIO.succeed(adminPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFabricConfiguration
  ) extends zio.aws.managedblockchain.model.MemberFabricConfiguration.ReadOnly {
    override val adminUsername: UsernameString =
      zio.aws.managedblockchain.model.primitives
        .UsernameString(impl.adminUsername())
    override val adminPassword: PasswordString =
      zio.aws.managedblockchain.model.primitives
        .PasswordString(impl.adminPassword())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFabricConfiguration
  ): zio.aws.managedblockchain.model.MemberFabricConfiguration.ReadOnly =
    new Wrapper(impl)
}
