package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  ClientRequestTokenString,
  FrameworkVersionString,
  TagValue,
  NameString,
  DescriptionString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNetworkRequest(
    clientRequestToken: ClientRequestTokenString,
    name: NameString,
    description: Option[DescriptionString] = None,
    framework: zio.aws.managedblockchain.model.Framework,
    frameworkVersion: FrameworkVersionString,
    frameworkConfiguration: Option[
      zio.aws.managedblockchain.model.NetworkFrameworkConfiguration
    ] = None,
    votingPolicy: zio.aws.managedblockchain.model.VotingPolicy,
    memberConfiguration: zio.aws.managedblockchain.model.MemberConfiguration,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest = {
    import CreateNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest
      .builder()
      .clientRequestToken(
        ClientRequestTokenString.unwrap(clientRequestToken): java.lang.String
      )
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .framework(framework.unwrap)
      .frameworkVersion(
        FrameworkVersionString.unwrap(frameworkVersion): java.lang.String
      )
      .optionallyWith(
        frameworkConfiguration.map(value => value.buildAwsValue())
      )(_.frameworkConfiguration)
      .votingPolicy(votingPolicy.buildAwsValue())
      .memberConfiguration(memberConfiguration.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateNetworkRequest.ReadOnly =
    zio.aws.managedblockchain.model.CreateNetworkRequest.wrap(buildAwsValue())
}
object CreateNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateNetworkRequest =
      zio.aws.managedblockchain.model.CreateNetworkRequest(
        clientRequestToken,
        name,
        description.map(value => value),
        framework,
        frameworkVersion,
        frameworkConfiguration.map(value => value.asEditable),
        votingPolicy.asEditable,
        memberConfiguration.asEditable,
        tags.map(value => value)
      )
    def clientRequestToken: ClientRequestTokenString
    def name: NameString
    def description: Option[DescriptionString]
    def framework: zio.aws.managedblockchain.model.Framework
    def frameworkVersion: FrameworkVersionString
    def frameworkConfiguration: Option[
      zio.aws.managedblockchain.model.NetworkFrameworkConfiguration.ReadOnly
    ]
    def votingPolicy: zio.aws.managedblockchain.model.VotingPolicy.ReadOnly
    def memberConfiguration
        : zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly
    def tags: Option[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestTokenString] =
      ZIO.succeed(clientRequestToken)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getFramework
        : ZIO[Any, Nothing, zio.aws.managedblockchain.model.Framework] =
      ZIO.succeed(framework)
    def getFrameworkVersion: ZIO[Any, Nothing, FrameworkVersionString] =
      ZIO.succeed(frameworkVersion)
    def getFrameworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkFrameworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "frameworkConfiguration",
      frameworkConfiguration
    )
    def getVotingPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchain.model.VotingPolicy.ReadOnly
    ] = ZIO.succeed(votingPolicy)
    def getMemberConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly
    ] = ZIO.succeed(memberConfiguration)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest
  ) extends zio.aws.managedblockchain.model.CreateNetworkRequest.ReadOnly {
    override val clientRequestToken: ClientRequestTokenString =
      zio.aws.managedblockchain.model.primitives
        .ClientRequestTokenString(impl.clientRequestToken())
    override val name: NameString =
      zio.aws.managedblockchain.model.primitives.NameString(impl.name())
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val framework: zio.aws.managedblockchain.model.Framework =
      zio.aws.managedblockchain.model.Framework.wrap(impl.framework())
    override val frameworkVersion: FrameworkVersionString =
      zio.aws.managedblockchain.model.primitives
        .FrameworkVersionString(impl.frameworkVersion())
    override val frameworkConfiguration: Option[
      zio.aws.managedblockchain.model.NetworkFrameworkConfiguration.ReadOnly
    ] = scala
      .Option(impl.frameworkConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkFrameworkConfiguration
          .wrap(value)
      )
    override val votingPolicy
        : zio.aws.managedblockchain.model.VotingPolicy.ReadOnly =
      zio.aws.managedblockchain.model.VotingPolicy.wrap(impl.votingPolicy())
    override val memberConfiguration
        : zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly =
      zio.aws.managedblockchain.model.MemberConfiguration
        .wrap(impl.memberConfiguration())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest
  ): zio.aws.managedblockchain.model.CreateNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
