package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  FrameworkVersionString,
  Timestamp,
  TagValue,
  ResourceIdString,
  NameString,
  DescriptionString,
  ArnString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Network(
    id: Option[ResourceIdString] = None,
    name: Option[NameString] = None,
    description: Option[DescriptionString] = None,
    framework: Option[zio.aws.managedblockchain.model.Framework] = None,
    frameworkVersion: Option[FrameworkVersionString] = None,
    frameworkAttributes: Option[
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes
    ] = None,
    vpcEndpointServiceName: Option[String] = None,
    votingPolicy: Option[zio.aws.managedblockchain.model.VotingPolicy] = None,
    status: Option[zio.aws.managedblockchain.model.NetworkStatus] = None,
    creationDate: Option[Timestamp] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    arn: Option[ArnString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Network = {
    import Network.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Network
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(framework.map(value => value.unwrap))(_.framework)
      .optionallyWith(
        frameworkVersion.map(value =>
          FrameworkVersionString.unwrap(value): java.lang.String
        )
      )(_.frameworkVersion)
      .optionallyWith(frameworkAttributes.map(value => value.buildAwsValue()))(
        _.frameworkAttributes
      )
      .optionallyWith(
        vpcEndpointServiceName.map(value => value: java.lang.String)
      )(_.vpcEndpointServiceName)
      .optionallyWith(votingPolicy.map(value => value.buildAwsValue()))(
        _.votingPolicy
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Network.ReadOnly =
    zio.aws.managedblockchain.model.Network.wrap(buildAwsValue())
}
object Network {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Network
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Network =
      zio.aws.managedblockchain.model.Network(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        framework.map(value => value),
        frameworkVersion.map(value => value),
        frameworkAttributes.map(value => value.asEditable),
        vpcEndpointServiceName.map(value => value),
        votingPolicy.map(value => value.asEditable),
        status.map(value => value),
        creationDate.map(value => value),
        tags.map(value => value),
        arn.map(value => value)
      )
    def id: Option[ResourceIdString]
    def name: Option[NameString]
    def description: Option[DescriptionString]
    def framework: Option[zio.aws.managedblockchain.model.Framework]
    def frameworkVersion: Option[FrameworkVersionString]
    def frameworkAttributes: Option[
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly
    ]
    def vpcEndpointServiceName: Option[String]
    def votingPolicy
        : Option[zio.aws.managedblockchain.model.VotingPolicy.ReadOnly]
    def status: Option[zio.aws.managedblockchain.model.NetworkStatus]
    def creationDate: Option[Timestamp]
    def tags: Option[Map[TagKey, TagValue]]
    def arn: Option[ArnString]
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getFramework
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getFrameworkVersion: ZIO[Any, AwsError, FrameworkVersionString] =
      AwsError.unwrapOptionField("frameworkVersion", frameworkVersion)
    def getFrameworkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("frameworkAttributes", frameworkAttributes)
    def getVpcEndpointServiceName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcEndpointServiceName", vpcEndpointServiceName)
    def getVotingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.VotingPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("votingPolicy", votingPolicy)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.NetworkStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Network
  ) extends zio.aws.managedblockchain.model.Network.ReadOnly {
    override val id: Option[ResourceIdString] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val name: Option[NameString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.NameString(value)
      )
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val framework: Option[zio.aws.managedblockchain.model.Framework] =
      scala
        .Option(impl.framework())
        .map(value => zio.aws.managedblockchain.model.Framework.wrap(value))
    override val frameworkVersion: Option[FrameworkVersionString] = scala
      .Option(impl.frameworkVersion())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.FrameworkVersionString(value)
      )
    override val frameworkAttributes: Option[
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly
    ] = scala
      .Option(impl.frameworkAttributes())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkFrameworkAttributes.wrap(value)
      )
    override val vpcEndpointServiceName: Option[String] =
      scala.Option(impl.vpcEndpointServiceName()).map(value => value: String)
    override val votingPolicy
        : Option[zio.aws.managedblockchain.model.VotingPolicy.ReadOnly] = scala
      .Option(impl.votingPolicy())
      .map(value => zio.aws.managedblockchain.model.VotingPolicy.wrap(value))
    override val status: Option[zio.aws.managedblockchain.model.NetworkStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.NetworkStatus.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val arn: Option[ArnString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Network
  ): zio.aws.managedblockchain.model.Network.ReadOnly = new Wrapper(impl)
}
