package zio.aws.managedblockchain.model
import java.lang.Integer
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  MemberListMaxResults,
  IsOwned,
  ResourceIdString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMembersRequest(
    networkId: ResourceIdString,
    name: Option[String] = None,
    status: Option[zio.aws.managedblockchain.model.MemberStatus] = None,
    isOwned: Option[IsOwned] = None,
    maxResults: Option[MemberListMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        isOwned.map(value => IsOwned.unwrap(value): java.lang.Boolean)
      )(_.isOwned)
      .optionallyWith(
        maxResults.map(value => MemberListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ListMembersRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListMembersRequest =
      zio.aws.managedblockchain.model.ListMembersRequest(
        networkId,
        name.map(value => value),
        status.map(value => value),
        isOwned.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkId: ResourceIdString
    def name: Option[String]
    def status: Option[zio.aws.managedblockchain.model.MemberStatus]
    def isOwned: Option[IsOwned]
    def maxResults: Option[MemberListMaxResults]
    def nextToken: Option[PaginationToken]
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getIsOwned: ZIO[Any, AwsError, IsOwned] =
      AwsError.unwrapOptionField("isOwned", isOwned)
    def getMaxResults: ZIO[Any, AwsError, MemberListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
  ) extends zio.aws.managedblockchain.model.ListMembersRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[zio.aws.managedblockchain.model.MemberStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.MemberStatus.wrap(value))
    override val isOwned: Option[IsOwned] = scala
      .Option(impl.isOwned())
      .map(value => zio.aws.managedblockchain.model.primitives.IsOwned(value))
    override val maxResults: Option[MemberListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.MemberListMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
  ): zio.aws.managedblockchain.model.ListMembersRequest.ReadOnly = new Wrapper(
    impl
  )
}
