package zio.aws.managedblockchain.model
import java.lang.Integer
import zio.aws.managedblockchain.model.primitives.{
  ProposalDurationInt,
  ThresholdPercentageInt
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApprovalThresholdPolicy(
    thresholdPercentage: Option[ThresholdPercentageInt] = None,
    proposalDurationInHours: Option[ProposalDurationInt] = None,
    thresholdComparator: Option[
      zio.aws.managedblockchain.model.ThresholdComparator
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ApprovalThresholdPolicy = {
    import ApprovalThresholdPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ApprovalThresholdPolicy
      .builder()
      .optionallyWith(
        thresholdPercentage.map(value =>
          ThresholdPercentageInt.unwrap(value): Integer
        )
      )(_.thresholdPercentage)
      .optionallyWith(
        proposalDurationInHours.map(value =>
          ProposalDurationInt.unwrap(value): Integer
        )
      )(_.proposalDurationInHours)
      .optionallyWith(thresholdComparator.map(value => value.unwrap))(
        _.thresholdComparator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ApprovalThresholdPolicy.ReadOnly =
    zio.aws.managedblockchain.model.ApprovalThresholdPolicy
      .wrap(buildAwsValue())
}
object ApprovalThresholdPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ApprovalThresholdPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ApprovalThresholdPolicy =
      zio.aws.managedblockchain.model.ApprovalThresholdPolicy(
        thresholdPercentage.map(value => value),
        proposalDurationInHours.map(value => value),
        thresholdComparator.map(value => value)
      )
    def thresholdPercentage: Option[ThresholdPercentageInt]
    def proposalDurationInHours: Option[ProposalDurationInt]
    def thresholdComparator
        : Option[zio.aws.managedblockchain.model.ThresholdComparator]
    def getThresholdPercentage: ZIO[Any, AwsError, ThresholdPercentageInt] =
      AwsError.unwrapOptionField("thresholdPercentage", thresholdPercentage)
    def getProposalDurationInHours: ZIO[Any, AwsError, ProposalDurationInt] =
      AwsError.unwrapOptionField(
        "proposalDurationInHours",
        proposalDurationInHours
      )
    def getThresholdComparator: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.ThresholdComparator
    ] = AwsError.unwrapOptionField("thresholdComparator", thresholdComparator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ApprovalThresholdPolicy
  ) extends zio.aws.managedblockchain.model.ApprovalThresholdPolicy.ReadOnly {
    override val thresholdPercentage: Option[ThresholdPercentageInt] = scala
      .Option(impl.thresholdPercentage())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ThresholdPercentageInt(value)
      )
    override val proposalDurationInHours: Option[ProposalDurationInt] = scala
      .Option(impl.proposalDurationInHours())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ProposalDurationInt(value)
      )
    override val thresholdComparator
        : Option[zio.aws.managedblockchain.model.ThresholdComparator] = scala
      .Option(impl.thresholdComparator())
      .map(value =>
        zio.aws.managedblockchain.model.ThresholdComparator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ApprovalThresholdPolicy
  ): zio.aws.managedblockchain.model.ApprovalThresholdPolicy.ReadOnly =
    new Wrapper(impl)
}
