package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetProposalRequest(
    networkId: ResourceIdString,
    proposalId: ResourceIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest = {
    import GetProposalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .proposalId(ResourceIdString.unwrap(proposalId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetProposalRequest.ReadOnly =
    zio.aws.managedblockchain.model.GetProposalRequest.wrap(buildAwsValue())
}
object GetProposalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetProposalRequest =
      zio.aws.managedblockchain.model.GetProposalRequest(networkId, proposalId)
    def networkId: ResourceIdString
    def proposalId: ResourceIdString
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getProposalId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(proposalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest
  ) extends zio.aws.managedblockchain.model.GetProposalRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val proposalId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.proposalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest
  ): zio.aws.managedblockchain.model.GetProposalRequest.ReadOnly = new Wrapper(
    impl
  )
}
