package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeFrameworkAttributes(
    fabric: Option[zio.aws.managedblockchain.model.NodeFabricAttributes] = None,
    ethereum: Option[zio.aws.managedblockchain.model.NodeEthereumAttributes] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NodeFrameworkAttributes = {
    import NodeFrameworkAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NodeFrameworkAttributes
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .optionallyWith(ethereum.map(value => value.buildAwsValue()))(_.ethereum)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NodeFrameworkAttributes.ReadOnly =
    zio.aws.managedblockchain.model.NodeFrameworkAttributes
      .wrap(buildAwsValue())
}
object NodeFrameworkAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NodeFrameworkAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NodeFrameworkAttributes =
      zio.aws.managedblockchain.model.NodeFrameworkAttributes(
        fabric.map(value => value.asEditable),
        ethereum.map(value => value.asEditable)
      )
    def fabric
        : Option[zio.aws.managedblockchain.model.NodeFabricAttributes.ReadOnly]
    def ethereum: Option[
      zio.aws.managedblockchain.model.NodeEthereumAttributes.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeFabricAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
    def getEthereum: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeEthereumAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("ethereum", ethereum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeFrameworkAttributes
  ) extends zio.aws.managedblockchain.model.NodeFrameworkAttributes.ReadOnly {
    override val fabric: Option[
      zio.aws.managedblockchain.model.NodeFabricAttributes.ReadOnly
    ] = scala
      .Option(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.NodeFabricAttributes.wrap(value)
      )
    override val ethereum: Option[
      zio.aws.managedblockchain.model.NodeEthereumAttributes.ReadOnly
    ] = scala
      .Option(impl.ethereum())
      .map(value =>
        zio.aws.managedblockchain.model.NodeEthereumAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeFrameworkAttributes
  ): zio.aws.managedblockchain.model.NodeFrameworkAttributes.ReadOnly =
    new Wrapper(impl)
}
