package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ProposalSummary(
    proposalId: Option[ResourceIdString] = None,
    description: Option[DescriptionString] = None,
    proposedByMemberId: Option[ResourceIdString] = None,
    proposedByMemberName: Option[NetworkMemberNameString] = None,
    status: Option[zio.aws.managedblockchain.model.ProposalStatus] = None,
    creationDate: Option[Timestamp] = None,
    expirationDate: Option[Timestamp] = None,
    arn: Option[ArnString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ProposalSummary = {
    import ProposalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
      .builder()
      .optionallyWith(
        proposalId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposalId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        proposedByMemberId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberId)
      .optionallyWith(
        proposedByMemberName.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ProposalSummary.ReadOnly =
    zio.aws.managedblockchain.model.ProposalSummary.wrap(buildAwsValue())
}
object ProposalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ProposalSummary =
      zio.aws.managedblockchain.model.ProposalSummary(
        proposalId.map(value => value),
        description.map(value => value),
        proposedByMemberId.map(value => value),
        proposedByMemberName.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        expirationDate.map(value => value),
        arn.map(value => value)
      )
    def proposalId: Option[ResourceIdString]
    def description: Option[DescriptionString]
    def proposedByMemberId: Option[ResourceIdString]
    def proposedByMemberName: Option[NetworkMemberNameString]
    def status: Option[zio.aws.managedblockchain.model.ProposalStatus]
    def creationDate: Option[Timestamp]
    def expirationDate: Option[Timestamp]
    def arn: Option[ArnString]
    def getProposalId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposalId", proposalId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getProposedByMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposedByMemberId", proposedByMemberId)
    def getProposedByMemberName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("proposedByMemberName", proposedByMemberName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.ProposalStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
  ) extends zio.aws.managedblockchain.model.ProposalSummary.ReadOnly {
    override val proposalId: Option[ResourceIdString] = scala
      .Option(impl.proposalId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val proposedByMemberId: Option[ResourceIdString] = scala
      .Option(impl.proposedByMemberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val proposedByMemberName: Option[NetworkMemberNameString] = scala
      .Option(impl.proposedByMemberName())
      .map(value =>
        zio.aws.managedblockchain.model.primitives
          .NetworkMemberNameString(value)
      )
    override val status
        : Option[zio.aws.managedblockchain.model.ProposalStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.managedblockchain.model.ProposalStatus.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val expirationDate: Option[Timestamp] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val arn: Option[ArnString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ProposalSummary
  ): zio.aws.managedblockchain.model.ProposalSummary.ReadOnly = new Wrapper(
    impl
  )
}
