package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  TagValue,
  NetworkMemberNameString,
  DescriptionString,
  ArnString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MemberConfiguration(
    name: NetworkMemberNameString,
    description: Option[DescriptionString] = None,
    frameworkConfiguration: zio.aws.managedblockchain.model.MemberFrameworkConfiguration,
    logPublishingConfiguration: Option[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    kmsKeyArn: Option[ArnString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberConfiguration = {
    import MemberConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberConfiguration
      .builder()
      .name(NetworkMemberNameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .frameworkConfiguration(frameworkConfiguration.buildAwsValue())
      .optionallyWith(
        logPublishingConfiguration.map(value => value.buildAwsValue())
      )(_.logPublishingConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyArn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.MemberConfiguration.wrap(buildAwsValue())
}
object MemberConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.MemberConfiguration =
      zio.aws.managedblockchain.model.MemberConfiguration(
        name,
        description.map(value => value),
        frameworkConfiguration.asEditable,
        logPublishingConfiguration.map(value => value.asEditable),
        tags.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def name: NetworkMemberNameString
    def description: Option[DescriptionString]
    def frameworkConfiguration
        : zio.aws.managedblockchain.model.MemberFrameworkConfiguration.ReadOnly
    def logPublishingConfiguration: Option[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ]
    def tags: Option[Map[TagKey, TagValue]]
    def kmsKeyArn: Option[ArnString]
    def getName: ZIO[Any, Nothing, NetworkMemberNameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getFrameworkConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchain.model.MemberFrameworkConfiguration.ReadOnly
    ] = ZIO.succeed(frameworkConfiguration)
    def getLogPublishingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logPublishingConfiguration",
      logPublishingConfiguration
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberConfiguration
  ) extends zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly {
    override val name: NetworkMemberNameString =
      zio.aws.managedblockchain.model.primitives
        .NetworkMemberNameString(impl.name())
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val frameworkConfiguration
        : zio.aws.managedblockchain.model.MemberFrameworkConfiguration.ReadOnly =
      zio.aws.managedblockchain.model.MemberFrameworkConfiguration
        .wrap(impl.frameworkConfiguration())
    override val logPublishingConfiguration: Option[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = scala
      .Option(impl.logPublishingConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
          .wrap(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyArn: Option[ArnString] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberConfiguration
  ): zio.aws.managedblockchain.model.MemberConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
