package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetNetworkResponse(
    network: Option[zio.aws.managedblockchain.model.Network] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse = {
    import GetNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse
      .builder()
      .optionallyWith(network.map(value => value.buildAwsValue()))(_.network)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly =
    zio.aws.managedblockchain.model.GetNetworkResponse.wrap(buildAwsValue())
}
object GetNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetNetworkResponse =
      zio.aws.managedblockchain.model
        .GetNetworkResponse(network.map(value => value.asEditable))
    def network: Option[zio.aws.managedblockchain.model.Network.ReadOnly]
    def getNetwork
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Network.ReadOnly] =
      AwsError.unwrapOptionField("network", network)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse
  ) extends zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly {
    override val network
        : Option[zio.aws.managedblockchain.model.Network.ReadOnly] = scala
      .Option(impl.network())
      .map(value => zio.aws.managedblockchain.model.Network.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse
  ): zio.aws.managedblockchain.model.GetNetworkResponse.ReadOnly = new Wrapper(
    impl
  )
}
