package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProposalsResponse(
    proposals: Option[
      Iterable[zio.aws.managedblockchain.model.ProposalSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse = {
    import ListProposalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse
      .builder()
      .optionallyWith(
        proposals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proposals)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListProposalsResponse.wrap(buildAwsValue())
}
object ListProposalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListProposalsResponse =
      zio.aws.managedblockchain.model.ListProposalsResponse(
        proposals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def proposals
        : Option[List[zio.aws.managedblockchain.model.ProposalSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getProposals: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.ProposalSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("proposals", proposals)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse
  ) extends zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly {
    override val proposals: Option[
      List[zio.aws.managedblockchain.model.ProposalSummary.ReadOnly]
    ] = scala
      .Option(impl.proposals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.managedblockchain.model.ProposalSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse
  ): zio.aws.managedblockchain.model.ListProposalsResponse.ReadOnly =
    new Wrapper(impl)
}
