package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMembersResponse(
    members: Option[Iterable[zio.aws.managedblockchain.model.MemberSummary]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListMembersResponse =
      zio.aws.managedblockchain.model.ListMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members
        : Option[List[zio.aws.managedblockchain.model.MemberSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.MemberSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
  ) extends zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly {
    override val members
        : Option[List[zio.aws.managedblockchain.model.MemberSummary.ReadOnly]] =
      scala
        .Option(impl.members())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.managedblockchain.model.MemberSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
  ): zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
