package zio.aws.macie.model
import zio.aws.macie.model.primitives.{MaxResults, NextToken}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMemberAccountsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest = {
    import ListMemberAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ListMemberAccountsRequest.ReadOnly =
    zio.aws.macie.model.ListMemberAccountsRequest.wrap(buildAwsValue())
}
object ListMemberAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ListMemberAccountsRequest =
      zio.aws.macie.model.ListMemberAccountsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
  ) extends zio.aws.macie.model.ListMemberAccountsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.macie.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.macie.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
  ): zio.aws.macie.model.ListMemberAccountsRequest.ReadOnly = new Wrapper(impl)
}
