package zio.aws.macie
import software.amazon.awssdk.services.macie.model.{
  DisassociateMemberAccountResponse,
  DisassociateS3ResourcesResponse,
  ListS3ResourcesRequest,
  ListS3ResourcesResponse,
  UpdateS3ResourcesRequest,
  AssociateS3ResourcesResponse,
  UpdateS3ResourcesResponse,
  AssociateMemberAccountResponse,
  ListMemberAccountsResponse,
  AssociateS3ResourcesRequest,
  DisassociateS3ResourcesRequest,
  DisassociateMemberAccountRequest,
  AssociateMemberAccountRequest,
  ListMemberAccountsRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.macie.model.ListS3ResourcesResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.macie.{
  MacieAsyncClientBuilder,
  MacieAsyncClient
}
import scala.jdk.CollectionConverters._
trait Macie extends AspectSupport[Macie] {
  val api: MacieAsyncClient
  def listMemberAccounts(
      request: zio.aws.macie.model.ListMemberAccountsRequest
  ): IO[AwsError, zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly]
  def associateS3Resources(
      request: zio.aws.macie.model.AssociateS3ResourcesRequest
  ): IO[AwsError, zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly]
  def listS3Resources(
      request: zio.aws.macie.model.ListS3ResourcesRequest
  ): IO[AwsError, ReadOnly]
  def disassociateMemberAccount(
      request: zio.aws.macie.model.DisassociateMemberAccountRequest
  ): IO[AwsError, Unit]
  def updateS3Resources(
      request: zio.aws.macie.model.UpdateS3ResourcesRequest
  ): IO[AwsError, zio.aws.macie.model.UpdateS3ResourcesResponse.ReadOnly]
  def associateMemberAccount(
      request: zio.aws.macie.model.AssociateMemberAccountRequest
  ): IO[AwsError, Unit]
  def disassociateS3Resources(
      request: zio.aws.macie.model.DisassociateS3ResourcesRequest
  ): IO[AwsError, zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly]
}
object Macie {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Macie] = customized(identity)
  def customized(
      customization: MacieAsyncClientBuilder => MacieAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Macie] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MacieAsyncClientBuilder => MacieAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Macie] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MacieAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[MacieAsyncClient, MacieAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[MacieAsyncClient, MacieAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new MacieImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class MacieImpl[R](
      override val api: MacieAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Macie
      with AwsServiceBase[R] {
    override val serviceName: String = "Macie"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MacieImpl[R1] = new MacieImpl(api, newAspect, r)
    def listMemberAccounts(
        request: zio.aws.macie.model.ListMemberAccountsRequest
    ): IO[AwsError, zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly] =
      asyncRequestResponse[
        ListMemberAccountsRequest,
        ListMemberAccountsResponse
      ]("listMemberAccounts", api.listMemberAccounts)(request.buildAwsValue())
        .map(zio.aws.macie.model.ListMemberAccountsResponse.wrap)
        .provideEnvironment(r)
    def associateS3Resources(
        request: zio.aws.macie.model.AssociateS3ResourcesRequest
    ): IO[AwsError, zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly] =
      asyncRequestResponse[
        AssociateS3ResourcesRequest,
        AssociateS3ResourcesResponse
      ]("associateS3Resources", api.associateS3Resources)(
        request.buildAwsValue()
      ).map(zio.aws.macie.model.AssociateS3ResourcesResponse.wrap)
        .provideEnvironment(r)
    def listS3Resources(
        request: zio.aws.macie.model.ListS3ResourcesRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListS3ResourcesRequest, ListS3ResourcesResponse](
        "listS3Resources",
        api.listS3Resources
      )(request.buildAwsValue())
        .map(zio.aws.macie.model.ListS3ResourcesResponse.wrap)
        .provideEnvironment(r)
    def disassociateMemberAccount(
        request: zio.aws.macie.model.DisassociateMemberAccountRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateMemberAccountRequest,
      DisassociateMemberAccountResponse
    ]("disassociateMemberAccount", api.disassociateMemberAccount)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateS3Resources(
        request: zio.aws.macie.model.UpdateS3ResourcesRequest
    ): IO[AwsError, zio.aws.macie.model.UpdateS3ResourcesResponse.ReadOnly] =
      asyncRequestResponse[UpdateS3ResourcesRequest, UpdateS3ResourcesResponse](
        "updateS3Resources",
        api.updateS3Resources
      )(request.buildAwsValue())
        .map(zio.aws.macie.model.UpdateS3ResourcesResponse.wrap)
        .provideEnvironment(r)
    def associateMemberAccount(
        request: zio.aws.macie.model.AssociateMemberAccountRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AssociateMemberAccountRequest,
      AssociateMemberAccountResponse
    ]("associateMemberAccount", api.associateMemberAccount)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disassociateS3Resources(
        request: zio.aws.macie.model.DisassociateS3ResourcesRequest
    ): IO[
      AwsError,
      zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateS3ResourcesRequest,
      DisassociateS3ResourcesResponse
    ]("disassociateS3Resources", api.disassociateS3Resources)(
      request.buildAwsValue()
    ).map(zio.aws.macie.model.DisassociateS3ResourcesResponse.wrap)
      .provideEnvironment(r)
  }
  def listMemberAccounts(
      request: zio.aws.macie.model.ListMemberAccountsRequest
  ): ZIO[
    zio.aws.macie.Macie,
    AwsError,
    zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMemberAccounts(request))
  def associateS3Resources(
      request: zio.aws.macie.model.AssociateS3ResourcesRequest
  ): ZIO[
    zio.aws.macie.Macie,
    AwsError,
    zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateS3Resources(request))
  def listS3Resources(
      request: zio.aws.macie.model.ListS3ResourcesRequest
  ): ZIO[zio.aws.macie.Macie, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listS3Resources(request))
  def disassociateMemberAccount(
      request: zio.aws.macie.model.DisassociateMemberAccountRequest
  ): ZIO[zio.aws.macie.Macie, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateMemberAccount(request))
  def updateS3Resources(
      request: zio.aws.macie.model.UpdateS3ResourcesRequest
  ): ZIO[
    zio.aws.macie.Macie,
    AwsError,
    zio.aws.macie.model.UpdateS3ResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateS3Resources(request))
  def associateMemberAccount(
      request: zio.aws.macie.model.AssociateMemberAccountRequest
  ): ZIO[zio.aws.macie.Macie, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateMemberAccount(request))
  def disassociateS3Resources(
      request: zio.aws.macie.model.DisassociateS3ResourcesRequest
  ): ZIO[
    zio.aws.macie.Macie,
    AwsError,
    zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateS3Resources(request))
}
