package zio.aws.macie
import zio.mock.{Proxy, Mock}
import zio.aws.macie.model.ListS3ResourcesResponse.ReadOnly
import zio.aws.macie.model.{
  ListS3ResourcesRequest,
  UpdateS3ResourcesRequest,
  AssociateS3ResourcesRequest,
  DisassociateS3ResourcesRequest,
  DisassociateMemberAccountRequest,
  AssociateMemberAccountRequest,
  ListMemberAccountsRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.macie.MacieAsyncClient
object MacieMock extends Mock[Macie] {
  object ListMemberAccounts
      extends Effect[
        ListMemberAccountsRequest,
        AwsError,
        zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly
      ]
  object AssociateS3Resources
      extends Effect[
        AssociateS3ResourcesRequest,
        AwsError,
        zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly
      ]
  object ListS3Resources
      extends Effect[ListS3ResourcesRequest, AwsError, ReadOnly]
  object DisassociateMemberAccount
      extends Effect[DisassociateMemberAccountRequest, AwsError, Unit]
  object UpdateS3Resources
      extends Effect[
        UpdateS3ResourcesRequest,
        AwsError,
        zio.aws.macie.model.UpdateS3ResourcesResponse.ReadOnly
      ]
  object AssociateMemberAccount
      extends Effect[AssociateMemberAccountRequest, AwsError, Unit]
  object DisassociateS3Resources
      extends Effect[
        DisassociateS3ResourcesRequest,
        AwsError,
        zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Macie] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Macie] { rts =>
        zio.ZIO.succeed {
          new Macie {
            val api: MacieAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Macie = this
            def listMemberAccounts(request: ListMemberAccountsRequest): IO[
              AwsError,
              zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly
            ] = proxy(ListMemberAccounts, request)
            def associateS3Resources(request: AssociateS3ResourcesRequest): IO[
              AwsError,
              zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly
            ] = proxy(AssociateS3Resources, request)
            def listS3Resources(
                request: ListS3ResourcesRequest
            ): IO[AwsError, ReadOnly] = proxy(ListS3Resources, request)
            def disassociateMemberAccount(
                request: DisassociateMemberAccountRequest
            ): IO[AwsError, Unit] = proxy(DisassociateMemberAccount, request)
            def updateS3Resources(request: UpdateS3ResourcesRequest): IO[
              AwsError,
              zio.aws.macie.model.UpdateS3ResourcesResponse.ReadOnly
            ] = proxy(UpdateS3Resources, request)
            def associateMemberAccount(
                request: AssociateMemberAccountRequest
            ): IO[AwsError, Unit] = proxy(AssociateMemberAccount, request)
            def disassociateS3Resources(
                request: DisassociateS3ResourcesRequest
            ): IO[
              AwsError,
              zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly
            ] = proxy(DisassociateS3Resources, request)
          }
        }
      }
    }
  }
}
