package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.macie.model.primitives.AWSAccountId
import scala.jdk.CollectionConverters._
final case class UpdateS3ResourcesRequest(
    memberAccountId: Optional[AWSAccountId] = Optional.Absent,
    s3ResourcesUpdate: Iterable[
      zio.aws.macie.model.S3ResourceClassificationUpdate
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.UpdateS3ResourcesRequest = {
    import UpdateS3ResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.UpdateS3ResourcesRequest
      .builder()
      .optionallyWith(
        memberAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.memberAccountId)
      .s3ResourcesUpdate(s3ResourcesUpdate.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.UpdateS3ResourcesRequest.ReadOnly =
    zio.aws.macie.model.UpdateS3ResourcesRequest.wrap(buildAwsValue())
}
object UpdateS3ResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.UpdateS3ResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.UpdateS3ResourcesRequest =
      zio.aws.macie.model.UpdateS3ResourcesRequest(
        memberAccountId.map(value => value),
        s3ResourcesUpdate.map { item =>
          item.asEditable
        }
      )
    def memberAccountId: Optional[AWSAccountId]
    def s3ResourcesUpdate
        : List[zio.aws.macie.model.S3ResourceClassificationUpdate.ReadOnly]
    def getMemberAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccountId", memberAccountId)
    def getS3ResourcesUpdate: ZIO[Any, Nothing, List[
      zio.aws.macie.model.S3ResourceClassificationUpdate.ReadOnly
    ]] = ZIO.succeed(s3ResourcesUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.UpdateS3ResourcesRequest
  ) extends zio.aws.macie.model.UpdateS3ResourcesRequest.ReadOnly {
    override val memberAccountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.memberAccountId())
      .map(value => zio.aws.macie.model.primitives.AWSAccountId(value))
    override val s3ResourcesUpdate
        : List[zio.aws.macie.model.S3ResourceClassificationUpdate.ReadOnly] =
      impl
        .s3ResourcesUpdate()
        .asScala
        .map { item =>
          zio.aws.macie.model.S3ResourceClassificationUpdate.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.UpdateS3ResourcesRequest
  ): zio.aws.macie.model.UpdateS3ResourcesRequest.ReadOnly = new Wrapper(impl)
}
