package zio.aws.macie.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.{MaxResults, NextToken, AWSAccountId}
import scala.jdk.CollectionConverters._
final case class ListS3ResourcesRequest(
    memberAccountId: Option[AWSAccountId] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest = {
    import ListS3ResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
      .builder()
      .optionallyWith(
        memberAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.memberAccountId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ListS3ResourcesRequest.ReadOnly =
    zio.aws.macie.model.ListS3ResourcesRequest.wrap(buildAwsValue())
}
object ListS3ResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ListS3ResourcesRequest =
      zio.aws.macie.model.ListS3ResourcesRequest(
        memberAccountId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def memberAccountId: Option[AWSAccountId]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getMemberAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccountId", memberAccountId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
  ) extends zio.aws.macie.model.ListS3ResourcesRequest.ReadOnly {
    override val memberAccountId: Option[AWSAccountId] = scala
      .Option(impl.memberAccountId())
      .map(value => zio.aws.macie.model.primitives.AWSAccountId(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.macie.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
  ): zio.aws.macie.model.ListS3ResourcesRequest.ReadOnly = new Wrapper(impl)
}
