package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.{ExceptionMessage, ErrorCode}
import scala.jdk.CollectionConverters._
final case class FailedS3Resource(
    failedItem: Option[zio.aws.macie.model.S3Resource] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ExceptionMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.FailedS3Resource = {
    import FailedS3Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.FailedS3Resource
      .builder()
      .optionallyWith(failedItem.map(value => value.buildAwsValue()))(
        _.failedItem
      )
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value =>
          ExceptionMessage.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.FailedS3Resource.ReadOnly =
    zio.aws.macie.model.FailedS3Resource.wrap(buildAwsValue())
}
object FailedS3Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.FailedS3Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.FailedS3Resource =
      zio.aws.macie.model.FailedS3Resource(
        failedItem.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def failedItem: Option[zio.aws.macie.model.S3Resource.ReadOnly]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ExceptionMessage]
    def getFailedItem
        : ZIO[Any, AwsError, zio.aws.macie.model.S3Resource.ReadOnly] =
      AwsError.unwrapOptionField("failedItem", failedItem)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ExceptionMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.FailedS3Resource
  ) extends zio.aws.macie.model.FailedS3Resource.ReadOnly {
    override val failedItem: Option[zio.aws.macie.model.S3Resource.ReadOnly] =
      scala
        .Option(impl.failedItem())
        .map(value => zio.aws.macie.model.S3Resource.wrap(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.macie.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ExceptionMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.macie.model.primitives.ExceptionMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.FailedS3Resource
  ): zio.aws.macie.model.FailedS3Resource.ReadOnly = new Wrapper(impl)
}
