package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListS3ResourcesResponse(
    s3Resources: Option[
      Iterable[zio.aws.macie.model.S3ResourceClassification]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse = {
    import ListS3ResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse
      .builder()
      .optionallyWith(
        s3Resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.s3Resources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ListS3ResourcesResponse.ReadOnly =
    zio.aws.macie.model.ListS3ResourcesResponse.wrap(buildAwsValue())
}
object ListS3ResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ListS3ResourcesResponse =
      zio.aws.macie.model.ListS3ResourcesResponse(
        s3Resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def s3Resources
        : Option[List[zio.aws.macie.model.S3ResourceClassification.ReadOnly]]
    def nextToken: Option[NextToken]
    def getS3Resources: ZIO[Any, AwsError, List[
      zio.aws.macie.model.S3ResourceClassification.ReadOnly
    ]] = AwsError.unwrapOptionField("s3Resources", s3Resources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse
  ) extends zio.aws.macie.model.ListS3ResourcesResponse.ReadOnly {
    override val s3Resources
        : Option[List[zio.aws.macie.model.S3ResourceClassification.ReadOnly]] =
      scala
        .Option(impl.s3Resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie.model.S3ResourceClassification.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse
  ): zio.aws.macie.model.ListS3ResourcesResponse.ReadOnly = new Wrapper(impl)
}
