package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListMemberAccountsResponse(
    memberAccounts: Option[Iterable[zio.aws.macie.model.MemberAccount]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse = {
    import ListMemberAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse
      .builder()
      .optionallyWith(
        memberAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberAccounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly =
    zio.aws.macie.model.ListMemberAccountsResponse.wrap(buildAwsValue())
}
object ListMemberAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ListMemberAccountsResponse =
      zio.aws.macie.model.ListMemberAccountsResponse(
        memberAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def memberAccounts: Option[List[zio.aws.macie.model.MemberAccount.ReadOnly]]
    def nextToken: Option[NextToken]
    def getMemberAccounts
        : ZIO[Any, AwsError, List[zio.aws.macie.model.MemberAccount.ReadOnly]] =
      AwsError.unwrapOptionField("memberAccounts", memberAccounts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse
  ) extends zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly {
    override val memberAccounts
        : Option[List[zio.aws.macie.model.MemberAccount.ReadOnly]] = scala
      .Option(impl.memberAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie.model.MemberAccount.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse
  ): zio.aws.macie.model.ListMemberAccountsResponse.ReadOnly = new Wrapper(impl)
}
