package zio.aws.macie.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class ListMemberAccountsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest = {
    import ListMemberAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ListMemberAccountsRequest.ReadOnly =
    zio.aws.macie.model.ListMemberAccountsRequest.wrap(buildAwsValue())
}
object ListMemberAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ListMemberAccountsRequest =
      zio.aws.macie.model.ListMemberAccountsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
  ) extends zio.aws.macie.model.ListMemberAccountsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.macie.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest
  ): zio.aws.macie.model.ListMemberAccountsRequest.ReadOnly = new Wrapper(impl)
}
