package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.AWSAccountId
import scala.jdk.CollectionConverters._
final case class AssociateS3ResourcesRequest(
    memberAccountId: Option[AWSAccountId] = None,
    s3Resources: Iterable[zio.aws.macie.model.S3ResourceClassification]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.AssociateS3ResourcesRequest = {
    import AssociateS3ResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.AssociateS3ResourcesRequest
      .builder()
      .optionallyWith(
        memberAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.memberAccountId)
      .s3Resources(s3Resources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.AssociateS3ResourcesRequest.ReadOnly =
    zio.aws.macie.model.AssociateS3ResourcesRequest.wrap(buildAwsValue())
}
object AssociateS3ResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.AssociateS3ResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.AssociateS3ResourcesRequest =
      zio.aws.macie.model.AssociateS3ResourcesRequest(
        memberAccountId.map(value => value),
        s3Resources.map { item =>
          item.asEditable
        }
      )
    def memberAccountId: Option[AWSAccountId]
    def s3Resources: List[zio.aws.macie.model.S3ResourceClassification.ReadOnly]
    def getMemberAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccountId", memberAccountId)
    def getS3Resources: ZIO[Any, Nothing, List[
      zio.aws.macie.model.S3ResourceClassification.ReadOnly
    ]] = ZIO.succeed(s3Resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.AssociateS3ResourcesRequest
  ) extends zio.aws.macie.model.AssociateS3ResourcesRequest.ReadOnly {
    override val memberAccountId: Option[AWSAccountId] = scala
      .Option(impl.memberAccountId())
      .map(value => zio.aws.macie.model.primitives.AWSAccountId(value))
    override val s3Resources
        : List[zio.aws.macie.model.S3ResourceClassification.ReadOnly] = impl
      .s3Resources()
      .asScala
      .map { item =>
        zio.aws.macie.model.S3ResourceClassification.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.AssociateS3ResourcesRequest
  ): zio.aws.macie.model.AssociateS3ResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
