package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.{Prefix, BucketName}
import scala.jdk.CollectionConverters._
final case class S3ResourceClassificationUpdate(
    bucketName: BucketName,
    prefix: Option[Prefix] = None,
    classificationTypeUpdate: zio.aws.macie.model.ClassificationTypeUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.S3ResourceClassificationUpdate = {
    import S3ResourceClassificationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.S3ResourceClassificationUpdate
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .classificationTypeUpdate(classificationTypeUpdate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.macie.model.S3ResourceClassificationUpdate.ReadOnly =
    zio.aws.macie.model.S3ResourceClassificationUpdate.wrap(buildAwsValue())
}
object S3ResourceClassificationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.S3ResourceClassificationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.S3ResourceClassificationUpdate =
      zio.aws.macie.model.S3ResourceClassificationUpdate(
        bucketName,
        prefix.map(value => value),
        classificationTypeUpdate.asEditable
      )
    def bucketName: BucketName
    def prefix: Option[Prefix]
    def classificationTypeUpdate
        : zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getClassificationTypeUpdate: ZIO[
      Any,
      Nothing,
      zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly
    ] = ZIO.succeed(classificationTypeUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.S3ResourceClassificationUpdate
  ) extends zio.aws.macie.model.S3ResourceClassificationUpdate.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.macie.model.primitives.BucketName(impl.bucketName())
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.macie.model.primitives.Prefix(value))
    override val classificationTypeUpdate
        : zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly =
      zio.aws.macie.model.ClassificationTypeUpdate
        .wrap(impl.classificationTypeUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.S3ResourceClassificationUpdate
  ): zio.aws.macie.model.S3ResourceClassificationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
