package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.AWSAccountId
import scala.jdk.CollectionConverters._
final case class DisassociateS3ResourcesRequest(
    memberAccountId: Option[AWSAccountId] = None,
    associatedS3Resources: Iterable[zio.aws.macie.model.S3Resource]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesRequest = {
    import DisassociateS3ResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesRequest
      .builder()
      .optionallyWith(
        memberAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.memberAccountId)
      .associatedS3Resources(associatedS3Resources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.DisassociateS3ResourcesRequest.ReadOnly =
    zio.aws.macie.model.DisassociateS3ResourcesRequest.wrap(buildAwsValue())
}
object DisassociateS3ResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.DisassociateS3ResourcesRequest =
      zio.aws.macie.model.DisassociateS3ResourcesRequest(
        memberAccountId.map(value => value),
        associatedS3Resources.map { item =>
          item.asEditable
        }
      )
    def memberAccountId: Option[AWSAccountId]
    def associatedS3Resources: List[zio.aws.macie.model.S3Resource.ReadOnly]
    def getMemberAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccountId", memberAccountId)
    def getAssociatedS3Resources
        : ZIO[Any, Nothing, List[zio.aws.macie.model.S3Resource.ReadOnly]] =
      ZIO.succeed(associatedS3Resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesRequest
  ) extends zio.aws.macie.model.DisassociateS3ResourcesRequest.ReadOnly {
    override val memberAccountId: Option[AWSAccountId] = scala
      .Option(impl.memberAccountId())
      .map(value => zio.aws.macie.model.primitives.AWSAccountId(value))
    override val associatedS3Resources
        : List[zio.aws.macie.model.S3Resource.ReadOnly] = impl
      .associatedS3Resources()
      .asScala
      .map { item =>
        zio.aws.macie.model.S3Resource.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesRequest
  ): zio.aws.macie.model.DisassociateS3ResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
