package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassificationTypeUpdate(
    oneTime: Option[zio.aws.macie.model.S3OneTimeClassificationType] = None,
    continuous: Option[zio.aws.macie.model.S3ContinuousClassificationType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate = {
    import ClassificationTypeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
      .builder()
      .optionallyWith(oneTime.map(value => value.unwrap))(_.oneTime)
      .optionallyWith(continuous.map(value => value.unwrap))(_.continuous)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly =
    zio.aws.macie.model.ClassificationTypeUpdate.wrap(buildAwsValue())
}
object ClassificationTypeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ClassificationTypeUpdate =
      zio.aws.macie.model.ClassificationTypeUpdate(
        oneTime.map(value => value),
        continuous.map(value => value)
      )
    def oneTime: Option[zio.aws.macie.model.S3OneTimeClassificationType]
    def continuous: Option[zio.aws.macie.model.S3ContinuousClassificationType]
    def getOneTime
        : ZIO[Any, AwsError, zio.aws.macie.model.S3OneTimeClassificationType] =
      AwsError.unwrapOptionField("oneTime", oneTime)
    def getContinuous: ZIO[
      Any,
      AwsError,
      zio.aws.macie.model.S3ContinuousClassificationType
    ] = AwsError.unwrapOptionField("continuous", continuous)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
  ) extends zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly {
    override val oneTime
        : Option[zio.aws.macie.model.S3OneTimeClassificationType] = scala
      .Option(impl.oneTime())
      .map(value => zio.aws.macie.model.S3OneTimeClassificationType.wrap(value))
    override val continuous
        : Option[zio.aws.macie.model.S3ContinuousClassificationType] = scala
      .Option(impl.continuous())
      .map(value =>
        zio.aws.macie.model.S3ContinuousClassificationType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
  ): zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly = new Wrapper(impl)
}
