package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie.model.primitives.{Prefix, BucketName}
import scala.jdk.CollectionConverters._
final case class S3ResourceClassification(
    bucketName: BucketName,
    prefix: Option[Prefix] = None,
    classificationType: zio.aws.macie.model.ClassificationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.S3ResourceClassification = {
    import S3ResourceClassification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.S3ResourceClassification
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .classificationType(classificationType.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.macie.model.S3ResourceClassification.ReadOnly =
    zio.aws.macie.model.S3ResourceClassification.wrap(buildAwsValue())
}
object S3ResourceClassification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.S3ResourceClassification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.S3ResourceClassification =
      zio.aws.macie.model.S3ResourceClassification(
        bucketName,
        prefix.map(value => value),
        classificationType.asEditable
      )
    def bucketName: BucketName
    def prefix: Option[Prefix]
    def classificationType: zio.aws.macie.model.ClassificationType.ReadOnly
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getClassificationType
        : ZIO[Any, Nothing, zio.aws.macie.model.ClassificationType.ReadOnly] =
      ZIO.succeed(classificationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.S3ResourceClassification
  ) extends zio.aws.macie.model.S3ResourceClassification.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.macie.model.primitives.BucketName(impl.bucketName())
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.macie.model.primitives.Prefix(value))
    override val classificationType
        : zio.aws.macie.model.ClassificationType.ReadOnly =
      zio.aws.macie.model.ClassificationType.wrap(impl.classificationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.S3ResourceClassification
  ): zio.aws.macie.model.S3ResourceClassification.ReadOnly = new Wrapper(impl)
}
