package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie.model.primitives.AWSAccountId
import scala.jdk.CollectionConverters._
final case class DisassociateMemberAccountRequest(
    memberAccountId: AWSAccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.DisassociateMemberAccountRequest = {
    import DisassociateMemberAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.DisassociateMemberAccountRequest
      .builder()
      .memberAccountId(AWSAccountId.unwrap(memberAccountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.macie.model.DisassociateMemberAccountRequest.ReadOnly =
    zio.aws.macie.model.DisassociateMemberAccountRequest.wrap(buildAwsValue())
}
object DisassociateMemberAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.DisassociateMemberAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.DisassociateMemberAccountRequest =
      zio.aws.macie.model.DisassociateMemberAccountRequest(memberAccountId)
    def memberAccountId: AWSAccountId
    def getMemberAccountId: ZIO[Any, Nothing, AWSAccountId] =
      ZIO.succeed(memberAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.DisassociateMemberAccountRequest
  ) extends zio.aws.macie.model.DisassociateMemberAccountRequest.ReadOnly {
    override val memberAccountId: AWSAccountId =
      zio.aws.macie.model.primitives.AWSAccountId(impl.memberAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.DisassociateMemberAccountRequest
  ): zio.aws.macie.model.DisassociateMemberAccountRequest.ReadOnly =
    new Wrapper(impl)
}
